require( "scripts/style.lua" );


kMainMenuButtonSound="audio/sfx/menu_click.ogg";
kMainMenuRolloverButtonSound="audio/sfx/menu_rollover.ogg";
MainMenuStyle = {
	parent = DefaultStyle,
	sound = kMainMenuButtonSound,
	rolloversound = kMainMenuRolloverButtonSound
};

GameModeFont = {
	standardFont,
	24,
	BorderColor
};

WelcomeFont = {
	standardFont,
	14,
	BorderColor
};

MenuFont = {
	standardFont,
	40,
	BorderColor
};

MyStuffFont = {
	standardFont,
	18,
	BorderColor
};

TipFont = {
	standardFont,
	24,
	BorderColor
};

CopyrightFont = {
  "fonts/default.mvec",
  12,
  Color(0,0,0,255);
};

TrademarkFont = {
  "fonts/default.mvec",
  8,
  Color(0,0,0,255);
};

RegisteredFont = {
  "fonts/default.mvec",
  12,
  Color(0,0,0,255);
};

MMPrivacyFont = {
  standardFont,
  10,
  BlackColor
};


MPDDComGraphics = {
	"menu/mpmenu/menu_button_ddDotcom-a",
	"menu/mpmenu/menu_button_ddDotcom-b",
	"menu/mpmenu/menu_button_ddDotcom-c"
};

MPDDComFont = {
	standardFont,
	18,
	BlackColor
};

MPDDComStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = MPDDComFont,
	graphics = MPDDComGraphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};


MyStuffEditGraphics = {
	"menu/mpmenu/arrowtray",
	"menu/mpmenu/arrowtray",
	"menu/mpmenu/arrowtray"
};

MyStuffEditFont = {
	standardFont,
	18,
	BlackColor
};

MyStuffEditStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = MyStuffEditFont,
	image = "menu/mpmenu/arrowtray",
	graphics = MyStuffEditGraphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 0
};




kRotationAmount = 3.0;

MenuButtonRotateStyle = {
	parent = DefaultStyle,
	x = 0, y = 0, 
	flags = kHAlignCenter + kVAlignCenter,
	rotation = kRotationAmount,
	rotationOriginX = kCenter,
	rotationOriginY = kCenter
};


kButtonTextShift = 4;




function SlideWindows()
	SlideMovingWindow('movinglogo', true);
	SlideMovingWindow('movingtitle', true);
	SlideMovingWindow('storetray', true);
	SlideMovingWindow('movingtray', true);
	SlideMovingWindow('movingbottom', true);
end




MakeDialog
{
	x = 0,
	y = 0,
	w = 800,
	h = 600,
	name = "mainmenumodal",
	

	
	Bitmap
	{ 
		name="backgroundimage",
		image="menu/mainmenu",	
			
		MainMenu
		{
			name="mainmenuwindow",
			SetStyle(MainMenuStyle);
			x = 0,
			y = 0,
			w = 800,
			h = 600,
			fit = false,
			podx = 438,
			pody = 184,
			podw = 334,
			podh = 112,
		
			
				
			Text
			{
				font = CopyrightFont,
				name="copyright",
				label="copyright",
				x=0,
				y=500,
				w=kMax,
				h=24,
				flags = kHAlignCenter + kVAlignCenter,
				padding = 0
			},
			
			
			
			
			Bitmap
			{
				x = 388,
				y = 3,
				image = "menu/mpmenu/tray",
				
				
				Text
				{
					font = MyStuffFont,
					label="mywaiter",
					x=20,
					y=20,
					w=160,
					h=30,
					flags = kHAlignCenter + kVAlignTop,
					padding = 0
				},
				
				FloWindow
				{
					x = 100,
					y = 95,
					frame = 2,
					usemywaiter = true,
					scale = 0.75
				};
				
				Text
				{
					font = MyStuffFont,
					label="mydiner",
					x=180,
					y=20,
					w=160,
					h=30,
					flags = kHAlignCenter + kVAlignTop,
					padding = 0
				},
				
				MyDinerWindow
				{
					x = 200,
					y = 50,
					w = 128,
					h = 96
				};
				
				
				Text
				{
					x = 180, y = 155,
					w = 130, h = 50,
					flags = kHAlignRight + kVAlignTop,
					label = "menu_playnow",
					font = MyStuffEditFont,
				};
			
				
				
				Button
				{
					x = 180, y = 20,
					w = 160, h = 150, 
					name="mydiner",
					type = kPush,
					command=
						function()
							if (Login(false, false)) then
								MetricEvent(eMyDinerMainMenuVisits);
								SelectMyDiner();
							end
						end;
					Bitmap
					{
						x=140,
						y=137,
						image = "menu/mpmenu/arrowtray",
					},
					SelectLayer(1),
					Bitmap
					{
						x=140,
						y=137,
						image = "menu/mpmenu/arrowtray_over",
					},
					SelectLayer(2),
					Bitmap
					{
						x=140,
						y=137,
						image = "menu/mpmenu/arrowtray_over",
					},
				};
				
				Text
				{
					x = 15, y = 155,
					w = 100, h = 50,
					flags = kHAlignRight + kVAlignTop,
					label = "menu_edit",
					font = MyStuffEditFont,
				};
				
				Button
				{
					x = 40, y = 20,
					w = 100, h = 150, 
					label='',
					command=
						function()
							if (Login(false, false)) then
								ForceMyWaiterCreation(false);
								MetricEvent(eMyWaiterMPVisits);
								SetMultiplayer("multi");
								CloseAllWindows();
								DoModal("scripts/floscloset.lua");
							end
						end;
					SelectLayer(0),
					Bitmap
					{
						x=85,
						y=137,
						image = "menu/mpmenu/arrowtray",
					},
					SelectLayer(1),
					Bitmap
					{
						x=85,
						y=137,
						image = "menu/mpmenu/arrowtray_over",
					},
					SelectLayer(2),
					Bitmap
					{
						x=85,
						y=137,
						image = "menu/mpmenu/arrowtray_over",
					},
				},
			},
			
			Bitmap
			{
				x = 16,
				y = 8,
				image = "menu/mpmenu/dinerdash_logo"
			};
			
			Bitmap
			{
				x = 227,
				y = 117,
				image = "menu/hometown_hero_gourmet"
			};
			
			

				
		
				
			SetStyle(MPPlayButtonStyle);
			
			Button
			{
				x=624,
				y=483,
				name="playbutton",
				label="play",
				command=
					function()
						DoModal('scripts/mydinerdashsubmenu.lua');
					end
			},

			
			SetStyle(DefaultStyle);
			
			SetStyle(DefaultStyle);
			LinkText
			{
				label = 'privacybutton',
				font = MMPrivacyFont,
				x = 250,
				y = 515,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
			
			LinkText
			{
				label = 'tosbutton',
				font = MMPrivacyFont,
				x = 500,
				y = 515,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
		
			
			SetStyle(DefaultStyle);
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'privacybutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../privacypolicy.html');
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'tosbutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../tos.html');
					end
			};
				
			
			MovingWindow
			{
				name="movingbottom",
				x=kCenter,y=-73,
				dirX = 0,
				dirY = 1,
				startoff = 1,
				onDelay = 0,
				Bitmap
				{
					x = 0,
					y = 0,
					image = "menu/bezel",
					
						
					AutoFitText
					{
						font = WelcomeFont,
						name = "playername",
						x=40,y=37,w=204,h=22,
						flags = kHAlignCenter + kVAlignCenter,
						label = ""
					};
					
					SetStyle(ChangePlayerButtonStyle);
					Button
					{
						x=267,
						y=42,
						name="changeplayer",
						label="login_logout",
						command=
							function()
								if (LoginSystemEnabled()) then
									if (IsLoggedIn(false)) then
										CloseAllWindows();
										Logout();
										LaunchInitialLoginScreen();
									else
										DoModal("scripts/chooseplayer.lua");
										SetAnonymousArea(true);
										local validUser = GetStrSetting('pfuser', '') == '' or IsLoggedIn(false) == true;
										while (not validUser) do
											DoModal("scripts/login.lua");
											validUser = GetStrSetting('pfuser', '') == '' or IsLoggedIn(false) == true;
											if (not validUser) then
												DoModal("scripts/chooseplayer.lua");
												validUser = GetStrSetting('pfuser', '') == '' or IsLoggedIn(false) == true;
											end
										end
										PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
									end
								else
									DoModal("scripts/chooseplayer.lua");
									if (IsLoggedIn(false)) then
										SetWindowText('changeplayer', GetString('login_logout'));
									end
								end
							end
					},
					
					SetStyle(MPDDComStyle);
					Button
					{
						x=367,
						y=42,
						name="dinerdashdotcom",
						label="dinerdashdotcom",
						command =
							function()
								LaunchWebBrowser("http://www.dinerdash.com");
							end
					},
					
					SetStyle(MainMenuButtonStyle1);
					
					Button
					{
						x=499,
						y=30,
						name="options",
						label="options",
						command=
							function()
								if (Login(true, false)) then
									DoModal("scripts/options.lua");
								end
							end
					},
					
					Button
					{
						x=591,
						y=30,
						name="store",
						label="store",
						command=
							function()
								if (Login(false, false)) then
									LaunchStore("");
								end
							end
					},
					
					SetStyle(MainMenuQuitStyle);
					
					Button
					{
						x=686,
						y=30,
						name="quit",
						label="quit",
						command=
							function()
								result = DisplayDialog { 
									"scripts/yesno.lua", 
									body ="quitconfirm",
									title = "",
									popthrough = true
								};
								if (result=='yes') then
									PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
								end
							end
					},
					
				};
				
				
			};
			
			
			
			
			
			
			
			

			
			
			SetStyle(MainMenuButtonStyle1);
			Button
			{
				x=5,
				y=500,
				name="moregames",
				label="moregames",
				type = kPush,
				xoffset = 1,
				yoffset = 1,
				command=
					function()
						DoModal("xsell/xsell.lua");
					end
			},
			
			
			
			SetStyle(DefaultStyle);
			
			
			
			Button
			{
				x=670,
				y=530,
				font = WelcomeFont,
				graphics = SolidButtonGraphics,
				name="editors",
				label="le_editors",
				type = kPush,
				xoffset = 1,
				yoffset = 1,
				command=
					function()
						if (Login(true, false)) then
							SetDefaultGameSettings();
							DoModal("scripts/leveleditor/editors.lua");
						end
						
					end
			},
		}
	}
}


PlayMainMenuMusic();
if (GetGlobalBoolSetting("new_multiplayer", true) == false) then
	EnableWindow("new_multiplayer", false);
end
if (GetGlobalBoolSetting("new_customize", true) == false) then
	EnableWindow("new_customize", false);
end
SetRestartScreen(GetMainMenuScript());
if (GetSessionSetting('launchugcrecent') == 'true') then
	GetUGCContent();
end

EnforceOnlineBuild();